package Lp;

use strict;
use vars qw($VERSION @ISA @EXPORT);

require Exporter;
require DynaLoader;

@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw( );
$VERSION = '0.43';

bootstrap Lp $VERSION;

# Preloaded perl methods go here.
# In the Lp package, everything is in the C code in lptlib.c,
# as interfaced by Lp.xs

1;
__END__
# Below is the stub of documentation for your module.

=head1 NAME

Lp - Perl extension for Linux parallel port access

=head1 SYNOPSIS

  use Lp;
  $handle = Lp::opendev("/dev/ppuser00");
  Lp::wr_data($handle, value);
  Lp::wr_ctrl($handle, value);
  $value = Lp::rd_data($handle);
  $value = Lp::rd_status($handle);
  $value = Lp::rd_ctrl($handle);
  Lp::closedev($handle);

=head1 DESCRIPTION

  Lp provides raw access to a PC parallel port from perl programs.
  Currently, only linux is supported, but supporting other unixes
  that already have a suitable parallel-port device driver shoudl be easy.

  Lp::opendev enables user programs to manipulate a parallel port\'s
  digital I/O signals by using the ppuser or ppdev driver, depending
  on which was detected at compile time.  On success, Lp::opendev()
  returns a handle that can be passed to the other routines; on
  failure it returns -1;

  If the ppdev driver (standard with 2.3 and 2.4 kernels) is in use,
  the parallel port devices are named, /dev/parport0, /dev/parport1,
  ... /dev/parportN.  If the older ppuser driver is used, as is
  typical with 2.2 kernels, the device names are /dev/ppuser00,
  /dev/ppuser11, etc.

  Lp can also be configured at compile time to use the ioperm() system
  call.  In this special case, no kernel driver is required but
  programs must be run as root, and only ISA-bus parallel ports on
  i386 architectures are supported.

  The other routines read and write bytes to and from the data,
  status, and control registers of the parallel printer port.

  When finished with the device, call Lp::closedev() to free up the port.

=head1 AUTHOR

Steve Tell, Microelectronics Systems Lab, University of North Carolina
at Chapel Hill Computer Science Department.  (tell@cs.unc.edu).

=head1 SEE ALSO

perl(1), ioperm(2).

=cut

