use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

print "Checking for ppdev.h or ppuser.h...\n";
if( -r "/usr/include/linux/ppdev.h") {
	print "...Found ppdev.h\n";
	$dflags = '-DHAVE_PPDEV_H';
} else {
	if( -r "/usr/include/linux/ppuser.h") {
		print "...Found ppuser.h\n";
		$dflags = '-DHAVE_PPUSER_H';
	} else {
		print "...neither ppdev nor ppuser found - using ioperm(2)\n";
	}
}

WriteMakefile(
	      'NAME'	=> 'Lp',
	      'VERSION_FROM' => 'Lp.pm', # finds $VERSION
	      'LIBS'	=> [''],   # e.g., '-lm' 
	      'DEFINE'	=> $dflags,     # e.g., '-DHAVE_SOMETHING' 
	      'INC'	=> '',     # e.g., '-I/usr/include/other' 
	      'MYEXTLIB'  => 'liblpt$(LIB_EXT)'
);

sub MY::postamble {
	'
all::static

static::liblpt$(LIB_EXT)

liblpt$(LIB_EXT): $(O_FILES)
	$(AR) cr $@ $(O_FILES)
	$(RANLIB) $@

rpm: Lp-$(VERSION).tar.gz
	cp Lp-$(VERSION).tar.gz /usr/src/redhat/SOURCES
	./perlmod2rpm Lp-$(VERSION).tar.gz

';
}

