# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN {print "1..6\n";}
END {print "not ok 1\n" unless $loaded;}
use Lp;
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

# which lp device to test with
$dev = "/dev/ppuser00";

$base = &Lp::opendev($dev);
if($base > 1) {
    print "ok 2\n";
} else {
    print "not ok 2 # $!\n";
    exit 1;
}

# test 3 succedes if we don't SIGSEGV here
Lp::wr_data($base, 0x5A);
print "ok 3\n";

$rc = &Lp::rd_data($base);
if($rc == 0x5A) {
    print "ok 4\n";
} else {
    printf "# read 0x%0x\n", $rc;
    print "not ok 4\n";
}

# test succedes if we don't SIGSEGV here
Lp::wr_ctrl($base, 0x5A);
print "ok 5\n";

$rc = &Lp::rd_ctrl($base);
if(($rc & 0x0f) == 0x0A) {
    print "ok 5\n";
} else {
    printf "# read 0x%0x\n", $rc;
    print "not ok 5\n";
}

$status = Lp::rd_status($base);
printf "ok 6  # status=0x%0x\n", $status;

Lp::wr_data($base, 0x0);

Lp::closedev($base);
print "ok 7\n";

