///////////////////////////////////////////////////////////////////////////
//
// in2fs.C -- convert .in file into ifsim fault-simulation setup file
//            Writes output to stdout
//
//////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "inparse.h"

static char *progname = "in2fs";
char edge_chars[] = "?FRB"; /* order must be same as defines in inparse.h */

//////////////////////////////////////////////////////////////////////////
// Print out usage info
//////////////////////////////////////////////////////////////////////////
static void 
usage()
{
	fprintf(stderr, "Usage:  %s [options] <infile>\n", progname);
	fprintf(stderr, "       <infile>      is a doirsim .in file\n");
	fprintf(stderr, "  options:\n");
	fprintf(stderr, "       -s <n>        Set fault seed percentage to <n>.\n");
	fprintf(stderr, "       -s <nodefile> Seed faults at nodes specified in\n");
	fprintf(stderr, "                     <nodefile>\n");
	exit(3);
}

///////////////////////////////////////////////////////////////////////////
// Main routine
//////////////////////////////////////////////////////////////////////////

int
main(int argc, char **argv)
{
	int i;
	int c;
	int some_rise=0, some_fall=0, some_both=0;
	extern char *optarg;
	extern int optind;
	extern int optopt;
	// flags & arguments
	char seedp[50];

	// parse arguments
	while((c = getopt(argc, argv, "s:")) != -1) {
		switch(c) {
		case 's':

		        strcpy(seedp, optarg);
		  
			//seedp = atoi(optarg);
			break;
		default:
			fprintf(stderr, "%s: Unrecognized option: -%c\n", progname, optopt);
			usage();
			break;
		}
	}
	if(optind + 1 != argc) {
		fprintf(stderr, "%s: input file not specified.\n", progname);
		usage();
	}

	// Parse infile header
	parse_infile_header(argv[optind]);

	//if(seedp > 0) {
        printf("seed %s\n", seedp);
	//}

	for (i = 0; i < OutNumSigs; i++) {
	    if (OutSigs[i].edgestyle == EDGE_FALL) some_fall = 1;
	    if (OutSigs[i].edgestyle == EDGE_RISE) some_rise = 1;
	    if (OutSigs[i].edgestyle == EDGE_BOTH) some_both = 1;
	}

	// Write out the "trigger" command for appropriate clock edge.
	// consider output for fault-simulation "9ns" after falling
	// edge of clock.  This is just under irsim's "10ns"
	// idea of how long each simlation step takes: essentialy,
	// wait a long time for things to propagate.
	// (used to be 99ns vs. 100ns, but the time step changed,
	// and it isn't obvious how to coordinate these two things.

	if (some_fall) {
	    printf("trigger Clk 0 9\n");
	    for (i = 0; i < OutNumSigs; i++)
		if(OutSigs[i].edgestyle == EDGE_FALL)
			printf("\t%s\n", OutSigs[i].name);
	    printf("***\n");
	}

	if (some_rise) {
	    printf("trigger Clk 1 9\n");
	    for (i = 0; i < OutNumSigs; i++)
		if(OutSigs[i].edgestyle == EDGE_RISE)
			printf("\t%s\n", OutSigs[i].name);
	    printf("***\n");
	}

	if (some_both) {
	    printf("trigger DblClk 0 9\n");
	    for (i = 0; i < OutNumSigs; i++)
		if(OutSigs[i].edgestyle == EDGE_BOTH)
			printf("\t%s\n", OutSigs[i].name);
	    printf("***\n");
	}

	exit(0);
}
