/*
 * verilog testbench created by in2vlogtb
 */

module bus2_runtest;

   reg Clk;
   reg [0:1] inbits;
   reg [0:1] outbits;
   wire [1:0] i_iBus1 = inbits[0:1];
   wire [1:0] o_oBus1;

   bus2 dut(
      .Clk(Clk),
      .iBus1(i_iBus1),
      .oBus1(o_oBus1)
   );

   integer ofp;
   integer ifp;
   initial begin
      $timeformat(-9, 5);
      ofp = $fopen("bus2.vout");
      if(ofp == 0) begin
         $display("Failed to open bus2.vout - aborting");
         $finish;
      end // if (ofp == 0)
      $fdisplay(ofp, "Doverilog simulation of bus2 using bus2.in\n");
      $fdisplay(ofp, "iBus1[1]");
      $fdisplay(ofp, " iBus1[0]");
      $fdisplay(ofp, "    oBus1[1]");
      $fdisplay(ofp, "     oBus1[0]");
      $fdisplay(ofp, "========");
   end

   integer cycle;
   initial begin
      Clk = 1;
      cycle = 0;
   end
   always begin
      #100 Clk = ~Clk;
       if(Clk == 1)
          cycle = cycle + 1;
   end

   always @(posedge Clk) begin
      #99
      if(cycle >= 1) begin
         $fwrite(ofp, "%b", i_iBus1[1]);
         $fwrite(ofp, "%b", i_iBus1[0]);
         $fwrite(ofp, " ");
         $fwrite(ofp, " ");
         $fwrite(ofp, "%b", o_oBus1[1]);
         $fwrite(ofp, "%b", o_oBus1[0]);
         $fwrite(ofp, " ");
         $fwrite(ofp, " ");
         $fwrite(ofp, " %s %0d", ((Clk == 1) ? "f" : "r"), cycle);
         $fwrite(ofp, " #%t", $time);
         $fwrite(ofp, "\n");
      end
   end


   initial begin
         inbits <= 2'b00;
        @(negedge Clk);
        @(negedge Clk) inbits <= 2'b01;
        @(negedge Clk) inbits <= 2'b10;
        @(negedge Clk) inbits <= 2'b11;
        @(negedge Clk) $finish;
   end

endmodule // bus2_runtest
