#
# dospice_hspice.pl -
# Configure dospice for use with HSPICE.
#

#
# return array of commands to be used as a pipeline to preprocess
# main netlist (.fa) file.
#
sub spice_get_fa_preproc_cmds
{
	my($rootname, @opts) = @_;
	my($optstr);
	$optstr = join(' ', @opts);
	
	return ($blib . "/cfa2hspice -n $rootname.nodealias $optstr");
}

#
# get the command to run spice.
#	this abstraction may have to change; may need to ruturn
#	a whole command string given more parameters.
#	especially if we actually try to implement spice_name=cazm
#
sub spice_get_command
{
	if($path_hspice) {
		return $path_hspice; # should be set in dotools.pl file
	} else {
		return "hspice"; # else, hope its in the $PATH
	}
}

#
# Return list of command line arguments to pass to spice simulator
# spice will be run as:
#	spice_get_command-result spice_get_args-result > .lis-file-name
#
sub spice_get_args
{
	my($input_name, $input_basename, $mt_flag) = @_;
	my(@args);

	if(defined($mt_flag)) {
		push(@args, '-mt', $mt_flag);
	}
	return(@args, $input_name);
}

#
# given the spice input file name, return the output file name that we
# expect it to put the transient simulation output in.
#
sub spice_get_outfile_name
{
	my($input_basename) = @_;
	return $input_basename . ".tr0";
}

# return name of spice output file format, for use with spice2out
sub spice_get_outfile_format
{
	return 'hspice';
}

#
# This one is specificly for Meta-Software/Avanti hspice.  
# The stupid program doesn't generate a useful exit status, instead
# we have to look for a string in a status file to tell if the run
# succeded or failed.
#
sub spice_outfile_hook
{
	my($rootname) = @_;
	my($stfile, $rc);
	$stfile = "$rootname.st0";

	if($norun_flag) {
		return 1;
	}

	if(! -r $stfile) {
		print STDERR "dospice: $stfile not found - $spice_name probably didn't run\n";
		exit 1;
	}
#
# We should probably code this ourselves, since not all greps have -q
#
#	$rc = system "grep -s -q 'hspice job concluded' $stfile > /dev/null";
	$rc = &my_grep('hspice job concluded', $stfile);
	if($rc != 0) {
		print STDERR "dospice: $stfile indicates hspice run failed:\n";
		# try to show error messages to user
		$rc = system "grep '^>error' $stfile 1>&2";
		if($rc) {
			print STDERR "dospice: See $rootname.lis for more information on hspice errors.\n";
		}
		
		exit 1;
	}
	return 1;
}

#
# grep-like routine for use above.
# returns 0 if expression found in file.
#
sub my_grep($$)
{
	my($expr, $file) = @_;
	my($line);
	open(GFILE, $file) || die "$file: $!";
	
	while($line = <GFILE>) {
		if($line =~ m/$expr/o) {
			close(GFILE);
			return 0;
		}
	}
	close(GFILE);
	return 1;
}

1;
