#
# dospice_spice3.pl -
# Configure dospice for use with Berkeley SPICE 3F5
#

#
# return array of commands to be used as a pipeline to preprocess
# main netlist (.fa) file.
#
sub spice_get_fa_preproc_cmds
{
	return ($blib . "/cfa2hspice");
}

#
# get the command to run spice.
#	this abstraction may have to change; may need to ruturn
#	a whole command string given more parameters.
#	especially if we actually try to implement spice_name=cazm
#
sub spice_get_command
{
	if($path_spice3) {
		return $path_spice3;	# should be set in dotools.pl file
	} else {
		return "spice3"; # else, hope its in the $PATH
	}
}

#
# Return list of command line arguments to pass to spice simulator
# spice will be run as:
#	spice_get_command-result spice_get_args-result > .lis-file-name
#
sub spice_get_args
{
	my($input_name, $input_basename) = @_;

	return('-b', 
	       '-n',
	       '-r', "${input_basename}.rsp",
	       $input_name);
}

#
# given the spice input file name, return the output file name that we
# expect it to put the transient simulation output in.
#
sub spice_get_outfile_name
{
	my($input_basename) = @_;
	return $input_basename;
}

# return name of spice output file format, for use with spice2out
# for spice3, we convert below.
sub spice_get_outfile_format
{
	return 'cazm';
}

#
# One of spice3's many areas of braindamage is that there's no way to
# get it to generate a data file with just the variables we want, in the
# order we want.  So we produce a full rawfile, and filter it here
# using the .plot list pulled out of the command file.
#
sub spice_outfile_hook
{
	my($input_basename) = @_;
	my($plotline, @plotitems, @plotnames, $err);
	my($p, $t);

# this grep is bogus: need to do +-continuation.
# probably should just fix spice3.
	$plotline = `egrep '^\.(probe|plot|graph)' $fn_cmd`;
	if($debug_flag) {
		print STDERR "plotline=$plotline\n";
	}
	($p, $t, @plotitems) = split(/\s+/, $plotline);
	@plotnames = grep {s/[a-zA-Z]\(//; s/\)//; 1;} @plotitems;

	if($#plotnames < 0) {
		print STDERR "dospice spice3 output hook: couldn't find plotlist in $fn_cmd\n";
		exit 1;
	}
	unshift(@plotnames, 'time');

	$err = &run_command("selecting plot variables from spice rawfile",
		    "$bbin/sp2sp",
		    '',
		    "${input_basename}",
			    '-t', 'spice3raw',
			    '-c', 'cazm',
			    '-f',
			    join(',',@plotnames),
			    "${input_basename}.rsp"
		    );

	if($err) {exit(2)};
	
	push(@tmpfiles, "{$input_basename}.rsp");
	return 1;
}

1;
