#
# dospice_starsim.pl -
# Configure dospice for use with Avanti's STARSIM
#

#
# return array of commands to be used as a filter-pipeline to preprocess
# main netlist (.fa) file.
#
sub spice_get_fa_preproc_cmds
{
	return ();
}

#
# get the command to run the simulator
#	this abstraction may have to change; may need to ruturn
#	a whole command string given more parameters.
#	especially if we actually try to implement spice_name=cazm
#
sub spice_get_command
{
	# wretched tool requires environmental namespace polution...
	if(!defined($ENV{'SIM_SPICE'}) && $path_hspice) {
		$ENV{'SIM_SPICE'} = $path_hspice;
	}

	if($path_hspice) {
		return $path_starsim; # should be set in dotools.pl file
	} else {
		return "star_sim"; # else, hope its in the $PATH
	}
}

#
# Return list of command line arguments to pass to spice simulator
# spice will be run as:
#	spice_get_command-result spice_get_args-result > .lis-file-name
#
sub spice_get_args
{
	my($input_name, $input_basename) = @_;

	return($input_name);
}

#
# given the spice input file name, return the output file name that we
# expect it to put the transient simulation output in.
#
sub spice_get_outfile_name
{
	my($input_basename) = @_;
	return $input_basename . ".xp";
}

# return name of spice output file format, for use with spice2out
sub spice_get_outfile_format
{
	return 'hspice';
}

#
# This one is specificly for Meta-Software/Avanti hspice.  
# The stupid program doesn't generate a useful exit status, instead
# we have to look for a string in a status file to tell if the run
# succeded or failed.
#
sub spice_outfile_hook
{
	my($rootname) = @_;
	my($stfile, $rc);
	$stfile = "$rootname.stat";

	return 1;   # bypass and see if we do OK without this.
	
	if($norun_flag) {
		return 1;
	}

	if(! -r $stfile) {
		print STDERR "dospice: $stfile not found - $spice_name probably didn't run\n";
		exit 1;
	}

	$rc = &my_grep('job concluded', $stfile);
	if($rc != 0) {
		print STDERR "dospice: $stfile indicates starsim run failed:\n";
		# try to show error messages to user
		$rc = system "grep '^>error' $stfile 1>&2";
		if($rc) {
			print STDERR "dospice: See $rootname.lis for more information on hspice errors.\n";
		}
		
		exit 1;
	}
	return 1;
}

#
# grep-like routine for use above.
# returns 0 if expression found in file.
#
sub my_grep($$)
{
	my($expr, $file) = @_;
	my($line);
	open(GFILE, $file) || die "$file: $!";
	
	while($line = <GFILE>) {
		if($line =~ m/$expr/o) {
			close(GFILE);
			return 0;
		}
	}
	close(GFILE);
	return 1;
}

1;
