
/*  A Bison parser, made from parse.y
 by  GNU Bison version 1.25
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	EOLN	258
#define	LOW	259
#define	CROSS	260
#define	HIGH	261
#define	VDD	262
#define	RISE	263
#define	FALL	264
#define	POWER	265
#define	VOLTAGE	266
#define	START	267
#define	TIME	268
#define	COMMA	269
#define	COLON	270
#define	LPAREN	271
#define	RPAREN	272
#define	EQUAL	273
#define	CAZM_HEADER	274
#define	MIN	275
#define	MAX	276
#define	PLUS	277
#define	MINUS	278
#define	MULT	279
#define	DIVIDE	280
#define	UMINUS	281
#define	FLOAT	282
#define	IDENT	283

#line 25 "parse.y"


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tcalc.h"

extern FILE *yyin;




/***********************************************************************/
/* Global variable declarations                                        */

float Start = 0.0;		  /* time start value */
float Vdd   = DEFAULT_VDD;	  /* global threshold parameters */
float L     = DEFAULT_VDD*0.1;
float X     = DEFAULT_VDD*0.5;
float H     = DEFAULT_VDD*0.9;

SIGNAL *SignalList[MAX_SIGNALS];  /* table of defined electrical signals */
int     NumSignals = 0;
SIGNAL *TraceList[MAX_SIGNALS];   /* table of signals being traced */
int     NumTraces = 0;

VAR *VarList[MAX_VARS];	          /* time variables */
int  NumVars = 0;

float Time;			  /* current time value */
float OldTime;			  /* time value at last tick */

int   ExitCode = 0;		  /* exit value of program */

/***********************************************************************/
/* Forward and external procedure declarations                         */

VAR *new_var();
VAR *lookup_var();
extern float expr_eval();
void barf();


#line 69 "parse.y"
typedef union {
  int     s_int;
  float   s_float;
  char    s_char[MAX_NAME_LEN];
  EXPR   *s_expr;
  SIGNAL *s_signal;
  VAR    *s_var;
  } YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		92
#define	YYFLAG		-32768
#define	YYNTBASE	29

#define YYTRANSLATE(x) ((unsigned)(x) <= 283 ? yytranslate[x] : 42)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     3,     4,     8,     9,    11,    15,    19,    23,    27,
    31,    36,    41,    46,    51,    55,    59,    63,    67,    71,
    75,    79,    83,    86,    88,    96,    98,   100,   102,   104,
   106,   108,   109,   115,   122,   129,   130,   136,   139,   140,
   144,   145,   148,   150
};

static const short yyrhs[] = {    30,
    35,     0,     0,    30,    31,     3,     0,     0,     1,     0,
    12,    18,    27,     0,     7,    18,    27,     0,     4,    18,
    27,     0,     5,    18,    27,     0,     6,    18,    27,     0,
     7,    40,    18,    27,     0,     4,    40,    18,    27,     0,
     5,    40,    18,    27,     0,     6,    40,    18,    27,     0,
    41,    18,    32,     0,    16,    32,    17,     0,    32,    20,
    32,     0,    32,    21,    32,     0,    32,    22,    32,     0,
    32,    23,    32,     0,    32,    24,    32,     0,    32,    25,
    32,     0,    23,    32,     0,    41,     0,    40,    15,    33,
    14,    34,    14,    27,     0,    27,     0,     8,     0,     9,
     0,     4,     0,     5,     0,     6,     0,     0,    36,    13,
    37,     3,    38,     0,    36,    13,    37,     3,    38,    10,
     0,    19,     3,     3,    28,    28,     3,     0,     0,    37,
    11,    16,    40,    17,     0,    37,    40,     0,     0,    38,
    39,     3,     0,     0,    39,    27,     0,    28,     0,    28,
     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
    95,    98,    99,   102,   103,   104,   108,   115,   119,   123,
   127,   134,   138,   142,   146,   155,   159,   166,   173,   180,
   187,   194,   201,   210,   216,   227,   237,   241,   247,   251,
   255,   263,   264,   265,   268,   275,   276,   280,   288,   289,
   301,   305,   315,   328
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","EOLN","LOW",
"CROSS","HIGH","VDD","RISE","FALL","POWER","VOLTAGE","START","TIME","COMMA",
"COLON","LPAREN","RPAREN","EQUAL","CAZM_HEADER","MIN","MAX","PLUS","MINUS","MULT",
"DIVIDE","UMINUS","FLOAT","IDENT","process","decls","decl","expr","rf","transition",
"traces","header","vars","data","paramlist","signal","var", NULL
};
#endif

static const short yyr1[] = {     0,
    29,    30,    30,    31,    31,    31,    31,    31,    31,    31,
    31,    31,    31,    31,    31,    32,    32,    32,    32,    32,
    32,    32,    32,    32,    32,    32,    33,    33,    34,    34,
    34,    35,    35,    35,    36,    37,    37,    37,    38,    38,
    39,    39,    40,    41
};

static const short yyr2[] = {     0,
     2,     0,     3,     0,     1,     3,     3,     3,     3,     3,
     4,     4,     4,     4,     3,     3,     3,     3,     3,     3,
     3,     3,     2,     1,     7,     1,     1,     1,     1,     1,
     1,     0,     5,     6,     6,     0,     5,     2,     0,     3,
     0,     2,     1,     1
};

static const short yydefact[] = {     2,
     0,     5,     0,     0,     0,     0,     0,     0,    44,     0,
     1,     0,     0,     0,    43,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     3,    36,     0,     8,     0,     9,
     0,    10,     0,     7,     0,     6,     0,     0,     0,     0,
    26,    44,    15,     0,    24,    12,    13,    14,    11,     0,
    39,     0,    38,     0,    23,     0,     0,     0,     0,     0,
     0,     0,     0,    41,     0,    16,    17,    18,    19,    20,
    21,    22,    27,    28,     0,    35,    34,     0,     0,     0,
    40,    42,    37,    29,    30,    31,     0,     0,    25,     0,
     0,     0
};

static const short yydefgoto[] = {    90,
     1,    10,    43,    75,    87,    11,    12,    38,    64,    78,
    44,    45
};

static const short yypact[] = {-32768,
     4,-32768,     0,     1,     6,    15,    -5,    14,-32768,    22,
-32768,    17,    43,    45,-32768,    55,    47,    57,    49,    59,
    51,    61,    53,    78,-32768,-32768,    -1,-32768,    56,-32768,
    58,-32768,    60,-32768,    62,-32768,    54,     3,    -1,    -1,
-32768,    69,    35,    71,-32768,-32768,-32768,-32768,-32768,    64,
-32768,    72,-32768,    28,-32768,    -1,    -1,    -1,    -1,    -1,
    -1,    38,    87,    44,    65,-32768,    41,    41,    46,    46,
-32768,-32768,-32768,-32768,    77,-32768,-32768,     9,    79,    63,
-32768,-32768,-32768,-32768,-32768,-32768,    80,    68,-32768,    97,
    98,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,   -19,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
    -3,    99
};


#define	YYLAST		100


static const short yytable[] = {    16,
    18,    20,    22,   -32,     2,    51,    -4,     3,     4,     5,
     6,    81,    23,    52,    39,     7,    24,    14,    17,    54,
    55,    40,     8,    19,    25,    41,    42,    15,    15,    26,
    15,     9,    21,    15,    53,    82,    67,    68,    69,    70,
    71,    72,    15,   -33,    66,    73,    74,    56,    57,    58,
    59,    60,    61,    77,    56,    57,    58,    59,    60,    61,
    27,    79,    58,    59,    60,    61,    84,    85,    86,    60,
    61,    28,    29,    30,    31,    32,    33,    34,    35,    36,
    37,    50,    46,   -43,    47,    62,    48,    65,    49,    76,
    80,    63,    15,    88,    89,    83,    91,    92,     0,    13
};

static const short yycheck[] = {     3,
     4,     5,     6,     0,     1,     3,     3,     4,     5,     6,
     7,     3,    18,    11,    16,    12,     3,    18,    18,    39,
    40,    23,    19,    18,     3,    27,    28,    28,    28,    13,
    28,    28,    18,    28,    38,    27,    56,    57,    58,    59,
    60,    61,    28,     0,    17,     8,     9,    20,    21,    22,
    23,    24,    25,    10,    20,    21,    22,    23,    24,    25,
    18,    65,    22,    23,    24,    25,     4,     5,     6,    24,
    25,    27,    18,    27,    18,    27,    18,    27,    18,    27,
     3,    28,    27,    15,    27,    15,    27,    16,    27,     3,
    14,    28,    28,    14,    27,    17,     0,     0,    -1,     1
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/local/share/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 196 "/usr/local/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 6:
#line 105 "parse.y"
{
		      Start = yyvsp[0].s_float;
		    ;
    break;}
case 7:
#line 109 "parse.y"
{
		      Vdd = yyvsp[0].s_float;
		      L   = 0.1 * yyvsp[0].s_float;
		      X   = 0.5 * yyvsp[0].s_float;
		      H   = 0.9 * yyvsp[0].s_float;
		    ;
    break;}
case 8:
#line 116 "parse.y"
{
		      L = yyvsp[0].s_float;
		    ;
    break;}
case 9:
#line 120 "parse.y"
{
		      X = yyvsp[0].s_float;
		    ;
    break;}
case 10:
#line 124 "parse.y"
{
		      H = yyvsp[0].s_float;
		    ;
    break;}
case 11:
#line 128 "parse.y"
{
		      yyvsp[-2].s_signal->Vdd = yyvsp[0].s_float;
		      yyvsp[-2].s_signal->L   = 0.1 * yyvsp[0].s_float;
		      yyvsp[-2].s_signal->X   = 0.5 * yyvsp[0].s_float;
		      yyvsp[-2].s_signal->H   = 0.9 * yyvsp[0].s_float;
		    ;
    break;}
case 12:
#line 135 "parse.y"
{
		      yyvsp[-2].s_signal->L   = yyvsp[0].s_float;
		    ;
    break;}
case 13:
#line 139 "parse.y"
{
		      yyvsp[-2].s_signal->X = yyvsp[0].s_float;
		    ;
    break;}
case 14:
#line 143 "parse.y"
{
		      yyvsp[-2].s_signal->H = yyvsp[0].s_float;
		    ;
    break;}
case 15:
#line 147 "parse.y"
{
		      yyvsp[-2].s_var->expr = yyvsp[0].s_expr;
		    ;
    break;}
case 16:
#line 156 "parse.y"
{
		      yyval.s_expr = yyvsp[-1].s_expr;
		    ;
    break;}
case 17:
#line 160 "parse.y"
{
		      yyval.s_expr = (EXPR *) malloc(sizeof(EXPR));
		      yyval.s_expr->type = MIN;
		      yyval.s_expr->arg1 = yyvsp[-2].s_expr;
		      yyval.s_expr->arg2 = yyvsp[0].s_expr;
		    ;
    break;}
case 18:
#line 167 "parse.y"
{
		      yyval.s_expr = (EXPR *) malloc(sizeof(EXPR));
		      yyval.s_expr->type = MAX;
		      yyval.s_expr->arg1 = yyvsp[-2].s_expr;
		      yyval.s_expr->arg2 = yyvsp[0].s_expr;
		    ;
    break;}
case 19:
#line 174 "parse.y"
{
		      yyval.s_expr = (EXPR *) malloc(sizeof(EXPR));
		      yyval.s_expr->type = PLUS;
		      yyval.s_expr->arg1 = yyvsp[-2].s_expr;
		      yyval.s_expr->arg2 = yyvsp[0].s_expr;
		    ;
    break;}
case 20:
#line 181 "parse.y"
{
		      yyval.s_expr = (EXPR *) malloc(sizeof(EXPR));
		      yyval.s_expr->type = MINUS;
		      yyval.s_expr->arg1 = yyvsp[-2].s_expr;
		      yyval.s_expr->arg2 = yyvsp[0].s_expr;
		    ;
    break;}
case 21:
#line 188 "parse.y"
{
		      yyval.s_expr = (EXPR *) malloc(sizeof(EXPR));
		      yyval.s_expr->type = MULT;
		      yyval.s_expr->arg1 = yyvsp[-2].s_expr;
		      yyval.s_expr->arg2 = yyvsp[0].s_expr;
		    ;
    break;}
case 22:
#line 195 "parse.y"
{
		      yyval.s_expr = (EXPR *) malloc(sizeof(EXPR));
		      yyval.s_expr->type = DIVIDE;
		      yyval.s_expr->arg1 = yyvsp[-2].s_expr;
		      yyval.s_expr->arg2 = yyvsp[0].s_expr;
		    ;
    break;}
case 23:
#line 202 "parse.y"
{
		      yyval.s_expr = (EXPR *) malloc(sizeof(EXPR));
		      yyval.s_expr->type  = UMINUS;
		      yyval.s_expr->arg1 = (EXPR *) malloc(sizeof(EXPR));
		      yyval.s_expr->arg1->type  = FLOAT;
		      yyval.s_expr->arg1->contents.value = 0.0;
		      yyval.s_expr->arg2 = yyvsp[0].s_expr;
		    ;
    break;}
case 24:
#line 211 "parse.y"
{
		      yyval.s_expr = (EXPR *) malloc(sizeof(EXPR));
		      yyval.s_expr->type = IDENT;
		      yyval.s_expr->contents.var  = yyvsp[0].s_var;
		    ;
    break;}
case 25:
#line 217 "parse.y"
{
		      yyval.s_expr = (EXPR *) malloc(sizeof(EXPR));
		      yyval.s_expr->type = CROSS;
		      yyval.s_expr->contents.trans.signal = yyvsp[-6].s_signal;
		      yyval.s_expr->contents.trans.rf     = yyvsp[-4].s_int;
		      yyval.s_expr->contents.trans.trans  = yyvsp[-2].s_int;
		      yyval.s_expr->contents.trans.num    = (int)yyvsp[0].s_float;
		      if (yyvsp[0].s_float != (float)(int)yyvsp[0].s_float || yyvsp[0].s_float < 0.0)
			error_out("Cycle number must be integer >= 0");
		    ;
    break;}
case 26:
#line 228 "parse.y"
{
		      yyval.s_expr = (EXPR *) malloc(sizeof(EXPR));
		      yyval.s_expr->type = FLOAT;
		      yyval.s_expr->contents.value = yyvsp[0].s_float;
		    ;
    break;}
case 27:
#line 238 "parse.y"
{
		      yyval.s_int = RISE;
		    ;
    break;}
case 28:
#line 242 "parse.y"
{
		      yyval.s_int = FALL;
		    ;
    break;}
case 29:
#line 248 "parse.y"
{
		      yyval.s_int = LOW;
		    ;
    break;}
case 30:
#line 252 "parse.y"
{
		      yyval.s_int = CROSS;
		    ;
    break;}
case 31:
#line 256 "parse.y"
{
		      yyval.s_int = HIGH;
		    ;
    break;}
case 35:
#line 269 "parse.y"
{
		      if (strcmp(yyvsp[-2].s_char, "TRANSIENT") != 0)
			error_out("garbled CAzM file header\n");
		    ;
    break;}
case 37:
#line 277 "parse.y"
{
		      TraceList[NumTraces++] = yyvsp[-1].s_signal;
		    ;
    break;}
case 38:
#line 281 "parse.y"
{
		      TraceList[NumTraces++] = yyvsp[0].s_signal;
		    ;
    break;}
case 40:
#line 290 "parse.y"
{
		      if (yyvsp[-1].s_int == NumTraces)
			{
			  tick();
			  OldTime = Time;
			}
		      else if (yyvsp[-1].s_int != -1) /* not empty line */
			error_out("bad data format");
		    ;
    break;}
case 41:
#line 302 "parse.y"
{
		      yyval.s_int = -1;
		    ;
    break;}
case 42:
#line 306 "parse.y"
{
		      if (yyvsp[-1].s_int == -1)
			Time = yyvsp[0].s_float;
		      else
			TraceList[yyvsp[-1].s_int]->V = yyvsp[0].s_float;
		      yyval.s_int = yyvsp[-1].s_int+1;
		    ;
    break;}
case 43:
#line 316 "parse.y"
{
		      SIGNAL *temp;

		      temp = lookup_signal(yyvsp[0].s_char);
		      if (temp)
			yyval.s_signal = temp;
		      else
			yyval.s_signal = new_signal(yyvsp[0].s_char);
		    ;
    break;}
case 44:
#line 329 "parse.y"
{
		      VAR *temp;

		      temp = lookup_var(yyvsp[0].s_char);
		      if (temp)
			yyval.s_var = temp;
		      else
			yyval.s_var = new_var(yyvsp[0].s_char);
		    ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 498 "/usr/local/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 340 "parse.y"


/*************************************************************************
**************************************************************************
**     Support routines for lexical analyzer and parser                 **
**************************************************************************
*************************************************************************/


/************************************************************************
Create a signal instance.  Initialize it.  Add it to SignalList.

On entry:
  name = name of signal
************************************************************************/
SIGNAL *new_signal (name)
     char *name;
{
  SIGNAL *new;

  new = (SIGNAL *) malloc (sizeof(SIGNAL));
  strcpy(new->name, name);
  new->Vdd   = Vdd;
  new->L     = L;
  new->X     = X;
  new->H     = H;
  new->state = PRE;
  new->nRL   = new->nRX = new->nRH =
  new->nFL   = new->nFX = new->nFH = 0;
  if (NumSignals < MAX_SIGNALS)
    SignalList[NumSignals++] = new;
  else
    barf("too many signals");
  return(new);
}


/************************************************************************
Create a time variable instance.  Initialize it.  Add it to VarList.

On entry:
  name = name of time variable
************************************************************************/
VAR *new_var (name)
     char *name;
{
  VAR *new;

  new = (VAR *) malloc (sizeof(VAR));
  strcpy(new->name, name);
  if (NumVars < MAX_VARS)
    VarList[NumVars++] = new;
  else
    barf("too many variables");
  return(new);
}


/************************************************************************
Return pointer to signal specified by 'name' (NULL if not found).

On entry:
  name = name of signal
On exit:
  return pointer to signal (NULL if not found)
************************************************************************/
SIGNAL *lookup_signal (name)
     char *name;
{
  int i;

  for (i = 0; i < NumSignals; i++)
    if (strcmp(name, SignalList[i]->name) == 0)
      return(SignalList[i]);
  
  return((SIGNAL *) NULL);
}


/************************************************************************
Return pointer to variable specified by 'name' (NULL if not found).

On entry:
  name = name of variable
On exit:
  return pointer to variable (NULL if not found)
************************************************************************/
VAR *lookup_var (name)
     char *name;
{
  int i;

  for (i = 0; i < NumVars; i++)
    if (strcmp(name, VarList[i]->name) == 0)
      return(VarList[i]);
  
  return((VAR *) NULL);
}


/************************************************************************
Make sure that all defined signals appear in TraceList.
************************************************************************/
void check_signals()
{
  int i, j, okay;

  for (i = 0; i < NumSignals; i++)
    {
      okay = FALSE;

      for (j = 0; j < NumTraces; j++)
	if (SignalList[i] == TraceList[j])
	  okay = TRUE;

      if (!okay)
	fprintf(stderr,"Warning: signal <%s> defined but not used\n",
		SignalList[i]->name);
    }
}


/************************************************************************
Evaluate the expressions defining each variable.
************************************************************************/
void
eval_vars()
{
  int i;

  for (i = 0; i < NumVars; i++)
    if (VarList[i]->expr)
      {
	VarList[i]->value = expr_eval(VarList[i]->expr);
	VarList[i]->valid = TRUE;
	printf("%s = %g\n",VarList[i]->name, VarList[i]->value);
      }
}


/************************************************************************
Syntax error routine.  Called when YACC perceives a syntax error.
************************************************************************/
void
yyerror (s)
     char *s;
{
  error_out(s);
}


/************************************************************************
Barf and die.  Print out last words.
************************************************************************/
void
barf (s)
     char *s;
{
  fprintf(stderr,"Fatal error: %s\n",s);
  exit(1);
}


/*************************************************************************
Prints a message informing the correct usage of the command, then exits.
****************************************************************************/
void
usage()
{
  fprintf(stderr, "\nUsage: tcalc [-V] [-v Vdd] [-s tzero] file*\n\n");
  exit(1);
}


/*************************************************************************
Main routine for tcalc. 
****************************************************************************/
int
main(int argc, char **argv)	/* main routine */
{
 	extern int optind;
	extern char *optarg;
	int c;

	int   verbose = FALSE;

	while ((c = getopt (argc, argv, "Vv:s:")) != EOF) {
		switch(c) {
		case 'V':
			verbose = 1;
			break;
		case 'v':
			Vdd = atof(optarg);
			H = 0.9*Vdd;
			X = 0.5*Vdd;
			L = 0.1*Vdd;
			break;
			
		case 's':
			Start = atof(optarg);
			break;

		default:
			ExitCode = 1;
			break;
		}
	}

	if(ExitCode) {
		usage();
		exit(ExitCode);
	}

  /* Process input */
	if(optind >= argc) { /* no files, use stdin */
		init_lexer("<stdin>");
		if(verbose)
			fprintf(stderr, "reading stdin\n");
		yyparse();
	} else {
		for(; optind < argc; optind++) { /* files or stdin */
			if(strcmp("-", argv[optind]) == 0) {
				init_lexer("<stdin>");
				yyin = stdin;
				if(verbose)
					fprintf(stderr, "reading stdin\n");
				yyparse();
			} else {
				init_lexer(argv[optind]);
				if ((yyin=fopen(argv[optind],"r"))==NULL) {
					perror(argv[optind]);
					exit(1);
				} else {
					if(verbose)
						fprintf(stderr, "reading %s\n", argv[optind]);
					yyparse();
					/* fclose(yyin); */
				}
			}
		}
	}
	check_signals();

	if (verbose)
		print_transitions();

	eval_vars();

	exit(ExitCode);
}
