%{  /* -*- mode: C -*- */
/* 

MODULE scan.lex --- lex code for tcalc program

DESCRIPTION

HISTORY
    6/6/88 -- Written by Steven Molnar
BUGS

---------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "tcalc.h"
#include "parse.h"

char 	       *FileName;                       /* name of input file */ 
int 		OldLineCnt, LineCnt;	        /* line count */
int             OldColCnt,  ColCnt;             /* column count */
extern int      ExitCode;	                /* exit value of program */
extern YYSTYPE	yylval;		                /* passed back to parser */

#define SRCPOS	  (OldColCnt = ColCnt, OldLineCnt = LineCnt, ColCnt += yyleng)

%}

SPACE		([ \t])
NAME		([_$@a-zA-Z][^ \t\n\-;,:=+*/()]*)
DIGITS	        ([0-9])+
EXP		([Ee][\-\+]?{DIGITS})
INT		([\-]?{DIGITS})
RATIONAL	({INT}("."{DIGITS}?)?|[\-]?{DIGITS}?"."{DIGITS})
FLOAT		({RATIONAL}{EXP}?)

%%


\n		{
			OldLineCnt = LineCnt;
			OldColCnt  = ColCnt;
			++LineCnt;
			ColCnt     = 1;
			return( EOLN );
		}
{SPACE}+ 	{
			SRCPOS;
		}
;.*             {
	                SRCPOS;
                }
^"*".*          {		
	                SRCPOS;
			return( CAZM_HEADER );
                }
Power(.|\n)*    {
			SRCPOS;     
			return( POWER );
		}
V|v		{
			SRCPOS;
			return( VOLTAGE );
		}
L|l		{
			SRCPOS;
			return( LOW );
		}
X|x		{
			SRCPOS;
			return( CROSS );
		}
H|h		{
			SRCPOS;
			return( HIGH );
		}
R|r		{
			SRCPOS;
			return( RISE );
		}
F|f		{
			SRCPOS;
			return( FALL );
		}
Vdd|VDD|vdd	{
			SRCPOS;
			return( VDD );
		}
Time|TIME|time	{
			SRCPOS;
			return( TIME );
		}
Start|START|start {
			SRCPOS;
			return( START );
		}
min|Min|MIN	{
			SRCPOS;
			return( MIN );
		}
max|Max|MAX	{
			SRCPOS;
			return( MAX );
		}
","		{
			SRCPOS;
			return( COMMA );
		}
":"		{
			SRCPOS;
			return( COLON );
		}
"="		{
			SRCPOS;
			return( EQUAL );
		}
"+"		{
			SRCPOS;
			return( PLUS );
		}
"-"		{
			SRCPOS;
			return( MINUS );
		}
"*"		{
			SRCPOS;
			return( MULT );
		}
"/"		{
			SRCPOS;
			return( DIVIDE );
		}
"("		{
			SRCPOS;
			return( LPAREN );
		}
")"		{
			SRCPOS;
			return( RPAREN );
		}
{FLOAT}|{INT} 	{
			SRCPOS;
		        yylval.s_float = (float) atof(yytext);
                        return ( FLOAT ); 
 		}

{NAME}		{
			SRCPOS;
			strcpy(yylval.s_char, yytext);
			return( IDENT );
		}
.		{
			SRCPOS;
			error_out("unrecognized input");
		}

%%


/************************************************************************
Initialize source position info for lexer.

On entry:
  fname = file name of current file
************************************************************************/
init_lexer( fname )
  char *fname;
{	
  FileName   = fname;
  OldLineCnt = LineCnt = 1;
  OldColCnt  = ColCnt  = 1;
}


/************************************************************************
Print an error message out

On entry:
  message = message text
************************************************************************/
error_out(message )
char	*message;
{
  fprintf(stderr,"\"%s\", line %d(%d): %s\n", FileName, OldLineCnt, OldColCnt,
	  message);
  ExitCode = 1;
}
