///////////////////////////////////////////////////////////////////////////
//
// inhdump.C -- debugging utility to dump out info from a .in file
//    as read by inparse routines.
//
// $Log: inhdump_old.C,v $
// Revision 1.1  2002/11/07 05:18:55  sgt
// Add new infile parser.  Old one still used by most cutils
// now require glib to build.
//
// Revision 1.2  1999/11/01 22:26:40  tell
// Dump out probe attribute if present.  minor changes to accomodate table-based
// attribute scheme.
//
// Revision 1.1  1999/11/01 20:02:00  tell
// Initial revision
//
// Revision 1.2  1998/06/02 19:06:13  tell
// Added attribute-callback to dump additional attributes
// changed input and output signal access to use new SigSet structure instead of
// seperate globals
//
// Revision 1.1  1998/05/29 17:38:55  tell
// Initial revision
//
//////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "inparse.h"

static char *progname = "in2ir";
static int g_verbose;

static void 
usage()
{
	fprintf(stderr, "Usage:  %s [options] <infile>\n", progname);
	fprintf(stderr, "        <infile>     is a doirsim .in file\n");
	fprintf(stderr, "  options:\n");
	fprintf(stderr, "        -v           verbose mode\n");

	exit(3);
}

int
main(int argc, char **argv)
{
	int i, j;
	int c;
	extern char *optarg;
	extern int optind;
	extern int optopt;

	// parse arguments
	while((c = getopt(argc, argv, "v")) != -1) {
		switch(c) {
		case 'v':
			g_verbose = 1;
			break;
		default:
			fprintf(stderr, "%s: Unrecognized option: -%c\n", progname, optopt);
			usage();
			break;
		}
	}
	if(optind + 1 != argc) {
		fprintf(stderr, "%s: input file not specified.\n", progname);
		usage();
	}

	InfileActiveEdge = 0;

	// Parse infile header
	parse_infile_header(argv[optind]);

	// Print out static signals
	for (i = 0; i < StatNumSigs; i++) {
		printf("static %s %d\n", StatSigs[i].name, StatSigs[i].val);
	}

	// inputs
	for (i = ISigs.nFields-1; i >= 0; i--) {
		printf("input %s (%d bits)\n", ISigs.Fields[i].name, ISigs.Fields[i].nsigs );
		for (j = 0; j < ISigs.Fields[i].nsigs; j++)
			printf("  %s\n", ISigs.Sigs[InFields[i].firstsig+j].name);
	}

	// outputs
	for (i = OSigs.nFields-1; i >= 0; i--) {
		printf("output %s (%d bits)", 
		       OSigs.Fields[i].name, OSigs.Fields[i].nsigs );
		if(OSigs.Fields[i].probestr)
			printf(" probe=\"%s\"", OSigs.Fields[i].probestr);
		putchar('\n');
		for (j = 0; j < OSigs.Fields[i].nsigs; j++)
			printf("  %s\n", OSigs.Sigs[OutFields[i].firstsig+j].name);
	}

	// monitor
	for (i = MonSigs.nFields-1; i >= 0; i--) {
		printf("monitor %s (%d bits)", 
		       MonSigs.Fields[i].name, MonSigs.Fields[i].nsigs );
		if(MonSigs.Fields[i].probestr)
			printf(" probe=\"%s\"", MonSigs.Fields[i].probestr);
		putchar('\n');
		for (j = 0; j < MonSigs.Fields[i].nsigs; j++)
			printf("  %s\n", MonSigs.Sigs[MonSigs.Fields[i].firstsig+j].name);
	}

	exit(0);
}

