//   -*- mode: C++ -*- ///////////////////////////////////////////////////
//
// inparse.h -- parsing routines for doirsim/docazm .in file
//
// Originaly by Steve Molnar; heavily modified by Steve Tell.
//////////////////////////////////////////////////////////////////////////

// Maximum defines
#define MAX_SIGS         4096   /* number of static, input, output signals */ 
#define MAX_FIELDS       1024	/* number of input and output fields       */ 
#define MAX_FIELD_SIGS    512   /* number of signals in a field            */
#define MAX_LINE_LEN     8192	/* length of an input line                 */ 
#define MAX_NAME_LEN      512   /* length of a signal name                 */
#define MAX_ITERATORS       4	/* number of iterators in a signal name    */

// Mnemonic defines for default fanout and delay values for signals
#define DEFAULT_FANOUT     10
#define DEFAULT_DELAY       0

// Mnemonic defines for ignore flags (signals to ignore in comparisons)
// IGNORE on an input also means to not drive the input into the DUT at
// all, and record the input as "x" in the output file.
#define IGNORE_NONE       0x0	/* default                                 */
#define IGNORE_DELAY      0x1	/* ignore setup times in analog simulation   */
#define IGNORE_SPICE      0x2	/* ignore values in analog simulation        */
#define IGNORE_CAZM       IGNORE_SPICE
#define IGNORE_IRSIM      0x4	/* ignore values in irsim sim.	           */
#define IGNORE_ALL        0x7	/* ignore values in all simulations.    */

// defines for signal edge style
#define EDGE_DEFAULT	0
#define EDGE_FALL	0x1	/* default. falling edge of clock */
#define EDGE_RISE	0x2	/* rising edge */
#define EDGE_BOTH	(EDGE_FALL|EDGE_RISE)	/* both edges */

// Typedefs for signals

typedef struct StatSigStruct {
  char    *name;
  int     val;
} STATSIG;

typedef struct SigStruct {
  char    *name;
  float   fanout;
  float   delay;
  int     ignore;
  int     edgestyle;
  char    *wavename;
} Sig;

typedef struct FieldStruct {
	char    *name;
	int     firstsig;
	int     nsigs;
	char *probestr; // string used in probe statements to print whole field
	// formatting information.  
	// non-binary I/O is not fully supported yet.
	int width;	// width of printed output field
	char conv;	// 'b', 'h', 'o', 'd'
	int leadzero;	// true=leading zeros, else spaces
	void *data;	// pointer for user structure.
} Field;

typedef struct SigSetStruct {
	int      nSigs;		         // Number of signals
	Sig      Sigs[MAX_SIGS];		 // List of signals 
	int      nFields;		         // Number of signal fields
	Field	 Fields[MAX_FIELDS];		 // List of signal fields
} SigSet;

// compatibility with old clients of inparse code:

#define INSIG Sig
#define OUTSIG Sig
#define INFIELD Field
#define OUTFIELD Field

#define InNumSigs   ISigs.nSigs
#define InNumFields ISigs.nFields
#define InFields    ISigs.Fields
#define InSigs      ISigs.Sigs

#define OutNumSigs   OSigs.nSigs
#define OutNumFields OSigs.nFields
#define OutFields    OSigs.Fields
#define OutSigs      OSigs.Sigs

// References to global variables filed in by parse_infile_header()

extern int      StatNumSigs;		         // Number of static signals
extern STATSIG  StatSigs[MAX_SIGS];		 // List of static signals

extern SigSet ISigs;		// input signals
extern SigSet OSigs;		// output signals
extern SigSet MonSigs;		// signals output but never compared

extern int	InfileActiveEdge;	// which edges get used; OR of
					// edgestyleof all InSigs and OutSigs
#ifndef __GNUC__
#define __attribute__(a)
#endif

// Procedure defines
void infile_error(int die, char *fmt, ...) 
	__attribute__((format (printf, 2, 3)));

void parse_infile_header(char *name);
int  parse_infile_vector(int *inflag,  char *invec,
			 int *outflag, char *outvec, char *line, int *edgep,
			 char **commentp);

extern void touppers(char *s);
extern void tolowers(char *s);
extern int get_infile_num_vectors(int outspresent);

// callback for InFile signal-field attributes
typedef void (*ATTRCB)(int id, char *value, Sig *sigt, Field *fld);
extern void set_attribute_parser(int id, ATTRCB afunc);

// attribute IDs 
// All possible attributes are listed here (and in inparse.C)
// so we can ignore known ones even if we don't parse them for a particular
// client of inparse.
#define SATTR_ETFO	1
#define SATTR_IGNORE	2
#define SATTR_FORMAT	3
#define SATTR_VPORT	4
#define SATTR_PROBE	5
