#include <stdio.h>
#include <strings.h>
#include <ctype.h>

extern int words (char *s, char *ptr[], int maxwords, char *whites,
		  char *ends, char *metas);
void subout (char *s);

#define	MAXLINE		300	/* maximum length of an input line */
#define	MAXWORDS	50	/* maximum number of words in an input line */
#define	MAXNAMES	35	/* maximum number of globals */
#define	MAXGLBLEN	20	/* maximum length of global nodename */
#define	MAXNLEN		100	/* maximum length of word in file */
#define	MAXSUBS		1000	/* maximum number of subs for each global */

struct {
    char name[MAXGLBLEN+1];	/* global nodename */
    int itself;			/* flag if global itself appeared as a nodename */
    int num;			/* number of nodenames for which global was substituted */
    char sub[MAXSUBS][MAXNLEN];	/* list of nodenames for which global was substitiuted */
} glb[MAXNAMES];

int numglb;			/* number of global nodenames */

int line_number = 0;

int
main(int argc, char **argv)
{
    int nw, i, j;
    char s[MAXLINE+5], *list[MAXWORDS+1];

    /* get list of global nodenames */
    if ((numglb = argc-1) > MAXNAMES) {
	fprintf (stderr, "Too many global nodenames (more than %d) in 'subglobs', exiting\n", MAXNAMES);
	exit (1);
    }
    for (i=0; i<numglb; i++) {
	if (strlen(argv[i+1]) > MAXGLBLEN) {
	    fprintf (stderr, "Global node name '%s' too long (more than %d characters), exiting\n", argv[i+1], MAXGLBLEN);
	    exit (1);
	}
	strcpy (glb[i].name, argv[i+1]);
	glb[i].num = 0;
	glb[i].itself = 0;
    }

    /* read line from input */
    while (fgets (s, MAXLINE+3, stdin) != NULL) {

	line_number++;

	if (strlen(s) > MAXLINE) {
	    fprintf (stderr, "Line %d too long (more than %d characters), exiting\n", line_number, MAXLINE);
	    exit (2);
	}

	/* break lines at whitespace */
	nw = words (s, list, MAXWORDS," \t", "\n", "");

	/* empty line */
	if (nw==0) {
		printf ("\n");
	} else if (nw<0) {	/* too many words */
	    fprintf (stderr, "Line %d too many words (more than %d words), exiting\n", line_number, MAXWORDS);
	    exit (2);
	} else {
		/* do substitution for each word */
		for (i=0; i<nw; i++)
			subout (list[i]);

		/* print line to output */
		for (i=0; i<nw-1; i++)
			printf ("%s ", list[i]);
		printf ("%s\n", list[nw-1]);
	}
    }

    /* print summary of substitutions made */
    for (i=0; i<numglb; i++) {
	fprintf (stderr, "%s =", glb[i].name);
	if (glb[i].itself) fprintf (stderr, " %s", glb[i].name);
	for (j=0; j<glb[i].num; j++)
	    fprintf (stderr, " %s", &glb[i].sub[j][0]);
	fprintf (stderr, "\n");
    }

    exit(0);
}

/*
 * do in-place substitution on a single word.
 */
void
subout (char *s)
{
    int i, j, fnd;
    char test[MAXNLEN+1];
    register char *beg, *ptr, *end;

    if (strlen(s)>MAXNLEN) {
	fprintf (stderr, "Word too long (more than %d characters) in line %d, exiting\n", MAXNLEN, line_number);
	exit (2);
    }

    ptr = s;
    beg = s;
    end = NULL;
    while (*ptr != '\0') {
	if (*ptr == '/') beg = ptr+1;
	if (*ptr == '_') end = ptr;
	ptr++;
    }
    if (end==NULL || end<=beg) end = ptr;

    ptr = test;
    while (beg != end) *ptr++ = *beg++;
    *ptr = '\0';

    for (i=0; i<numglb; i++) {
	if (strcmp (s, glb[i].name) == 0) {
	    glb[i].itself = 1;
	}
	else if (strcmp (test, glb[i].name) == 0) {
	    if (glb[i].num >= MAXSUBS) {
		fprintf (stderr, "Too many substitutions for global '%s', sayonara sucka\n", glb[i].name);
		exit (2);
	    }
	    strcpy (glb[i].sub[glb[i].num], s);
	    for (fnd=j=0; j<glb[i].num; j++) if (strcmp(s, glb[i].sub[j])==0) fnd = 1;
	    if (!fnd) glb[i].num += 1;
	    strcpy (s, test);
	}
    }
}
