#include <stdio.h>

int isfoundin (char c, char *str);

int
words (char *s,		/* input: character string */
       char *ptr[],	/* output: array of pointers to words */
       int maxwords,	/* max number of words, error if exceeded */
       char *whites,	/* string containing white-space characters */
       char *ends,	/* string containing "end" characters */
       char *metas)	/* string of 2 delimiting characters */
/* 's' is a string terminated by a null chacracter or by one of the characters
	in "ends"
 it is divided into words wherever a character in "whites" appears,
	and a null character is placed at the end of each word
 'words' returns the number of words found
 the array of pointers 'ptr' must be at least one longer than 'maxwords'
 if more than 'maxwords' words are found, 'words' returns
	-1 * (number of words found)
 pointers to beginnings of the words are placed in the array of pointers 'ptr',
	and the array is terminated by a NULL pointer
 the string 'metas' may contain two characters which enclose a word, for
	example if 'metas' contains "()", anything contained within parentheses
	(except characters in "ends") is considered to be a word;
	the pointer for the word will point to the first position after the
	'(' and both meta characters are replaced by nulls
 'metas' should be a null string to disable this feature */
{
    int err, inword, inmeta, i, nwords;

    err = inword = inmeta = nwords = 0;

    for (i=0; s[i]!='\0'  && !isfoundin(s[i],ends); i++) {

	if (!inword) {
	    if (s[i] == metas[0] || !isfoundin (s[i], whites)) {
		inword = 1;
		if (inmeta = (s[i] == metas[0])) 
			s[i] = '\0';
		if (nwords >= maxwords) {
		    err = 1;
		    ptr[maxwords] = NULL;
		}
		else {
		    ptr[nwords] = s + i + inmeta;
		}
		nwords++;
	    }
	    else {
		s[i] = '\0';
	    }
	}

	else if (inmeta) {
	    if (s[i] == metas[1]) {
		s[i] = '\0';
		inword = inmeta = 0;
	    }
	}

	else {
	    if (isfoundin(s[i], whites)) {
		s[i] = '\0';
		inword = 0;	
	    }
	}
    }

    s[i] = '\0';
    ptr[nwords] = NULL;

    if (err) return (-nwords);
    else return (nwords);
}

/* routine returns 1 IFF 'c' occurs in null-terminated string '*str' */
int
isfoundin (char c, char *str)
{
    while (*str != '\0') {
	if (c == *str) return 1;
	str++;
    }
    return 0;
}
