;;; infile-mode.el --- mode for editing dotools .in files
;;  Steve Tell, June 1997
;;  hacked up from asm-mode.el 1.7

;; Copyright (C) 1991 Free Software Foundation, Inc.

;; Author: Eric S. Raymond <esr@snark.thyrsus.com>
;; Last-Modified: 14 Jul 1992
;; Keywords: tools, languages

;; This file is part of XEmacs.

;; XEmacs is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XEmacs is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Synched up with: FSF 19.28.

;;; Commentary:

;; This mode was written by Eric S. Raymond <esr@snark.thyrsus.com>,
;; inspired by an earlier asm-mode by Martin Neitzel.

;; This minor mode is based on text mode.  It defines a private abbrev table
;; that can be used to save abbrevs.  It binds just these
;; keys:
;;
;;	TAB		tab to next tab stop
;;	:		outdent preceding section label, 
;;

;; This mode runs two hooks:
;;   2) an asm-mode-hook at the end of initialization.

;;; Code:

(defvar infile-mode-syntax-table nil
  "Syntax table used while in Infile mode.")

(defvar infile-mode-abbrev-table nil
  "Abbrev table used while in Infile mode.")
(define-abbrev-table 'infile-mode-abbrev-table ())

(defvar infile-mode-map nil
  "Keymap for Infile mode.")

(if infile-mode-map
    nil
  (setq infile-mode-map (make-sparse-keymap))
  (set-keymap-name infile-mode-map 'infile-mode-map)
; (define-key infile-mode-map ":"		'infile-colon)
  (define-key infile-mode-map "\C-i"		'tab-to-tab-stop)
  (define-key infile-mode-map "\C-c\C-i"	'infile-invert-bit)
  (define-key infile-mode-map [kp_subtract]	'infile-invert-bit)
  (define-key infile-mode-map [kp_divide]	'infile-one-bit)
  (define-key infile-mode-map [kp_multiply]	'infile-zero-bit)
  )

;;
;; Variables controlling fontification
;;
(defvar infile-keywords '("ETFO" ))

(defconst infile-font-lock-keywords
      (list
       ;; Fontify [[ ]] expressions
       ;;'("\\(\\[.*\\]\\)"  1 font-lock-doc-string-face t)
       ;; Fontify keywords
       (cons (concat
              "\\(\\<"
              (mapconcat 'identity infile-keywords "\\>\\|\\<")
              "\\>\\)")
             1)
       ;; Fontify section labels
       '("\\(^[A-Za-z_0-9]+\\):" 1 font-lock-function-name-face)
       ))

(put 'infile-mode  'font-lock-keywords 'infile-font-lock-keywords)

;;;###autoload
(defun infile-mode ()
  "Major mode for editing typical .in files for the dotools.
Features a private abbrev table and the following bindings:

\\[infile-colon]\toutdent a preceding label, tab to next tab stop.
\\[tab-to-tab-stop]\ttab to next tab stop.

Turning on Infile mode runs the hook `infile-mode-hook' at the end of initialization.

Special commands:\\{infile-mode-map}
"
  (interactive)
  (kill-all-local-variables)
  (use-local-map infile-mode-map)
  (setq mode-name "Infile")
  (setq major-mode 'infile-mode)
  (setq local-abbrev-table infile-mode-abbrev-table)
  (make-local-variable 'infile-mode-syntax-table)
  (setq infile-mode-syntax-table (make-syntax-table))
  (set-syntax-table infile-mode-syntax-table)
  (modify-syntax-entry ?#  "<" infile-mode-syntax-table)
  (modify-syntax-entry ?\n ">" infile-mode-syntax-table)
      
  (setq fill-prefix "\t")
  (run-hooks 'infile-mode-hook)
  )


(defun infile-colon ()
  "Insert a colon; if it follows a section label, delete the label's indentation."
  (interactive)
  (save-excursion
    (beginning-of-line)
    (if (looking-at "[ \t]+\\(\\sw\\|\\s_\\)+$")
	(delete-horizontal-space)))
  (insert ":")
  (insert "\n")
  )

(defun infile-invert-bit ()
  "If current character is a 0 or 1, invert the bit."
  (interactive)
    (cond
     ((= (following-char) ?0) (progn (delete-char 1) (insert "1")))
     ((= (following-char) ?1) (progn (delete-char 1) (insert "0")))
     (t (forward-char))
     )
)

(defun infile-zero-bit ()
  "If current character is in [1XZ], set bit to zero."
  (interactive)
    (cond
     ((looking-at "[1XZxz]") (progn (delete-char 1) (insert "0")))
     (t (forward-char))
     )
)

(defun infile-one-bit ()
  "If current character is in [0XZ], set bit to one."
  (interactive)
    (cond
     ((looking-at "[0XZxz]") (progn (delete-char 1) (insert "1")))
     (t (forward-char))
     )
)
;;; infile-mode.el ends here
