/*
 * verilog testbench created by in2vlogtb
 */

module aoi_runtest;

   reg Clk;
   reg [0:3] inbits;
   reg outbits;
   wire i_a1 = inbits[0];
   wire i_a2 = inbits[1];
   wire i_b1 = inbits[2];
   wire i_b2 = inbits[3];

   aoi dut(
      .Clk(Clk),
      .a1(i_a1),
      .a2(i_a2),
      .b1(i_b1),
      .b2(i_b2)
   );

   integer ofp;
   integer ifp;
   initial begin
      $timeformat(-9, 5);
      ofp = $fopen("aoi.vout");
      if(ofp == 0) begin
         $display("Failed to open aoi.vout - aborting");
         $finish;
      end // if (ofp == 0)
      $fdisplay(ofp, "Doverilog simulation of aoi using aoi.in\n");
      $fdisplay(ofp, "a1");
      $fdisplay(ofp, " a2");
      $fdisplay(ofp, "   b1");
      $fdisplay(ofp, "    b2");
      $fdisplay(ofp, "       out");
      $fdisplay(ofp, "==========");
   end

   integer cycle;
   initial begin
      Clk = 1;
      cycle = 0;
   end
   always begin
      #100 Clk = ~Clk;
       if(Clk == 1)
          cycle = cycle + 1;
   end

   always @(posedge Clk) begin
      #99
      if(cycle >= 1) begin
         $fwrite(ofp, "%b", i_a1);
         $fwrite(ofp, "%b", i_a2);
         $fwrite(ofp, " ");
         $fwrite(ofp, "%b", i_b1);
         $fwrite(ofp, "%b", i_b2);
         $fwrite(ofp, " ");
         $fwrite(ofp, " ");
         $fwrite(ofp, "%b", dut.out);
         $fwrite(ofp, " ");
         $fwrite(ofp, " ");
         $fwrite(ofp, " %s %0d", ((Clk == 1) ? "f" : "r"), cycle);
         $fwrite(ofp, " #%t", $time);
         $fwrite(ofp, "\n");
      end
   end


   initial begin
         inbits <= 4'b1111;
        @(negedge Clk);
        @(negedge Clk) inbits <= 4'b1011;
        @(negedge Clk) inbits <= 4'b0111;
        @(negedge Clk) inbits <= 4'b0011;
        @(negedge Clk) inbits <= 4'b1110;
        @(negedge Clk) inbits <= 4'b1101;
        @(negedge Clk) inbits <= 4'b1100;
        $fdisplay(ofp, "# ");
        @(negedge Clk) inbits <= 4'b0000;
        @(negedge Clk) inbits <= 4'b0100;
        @(negedge Clk) inbits <= 4'b1000;
        @(negedge Clk) inbits <= 4'b0010;
        @(negedge Clk) inbits <= 4'b0101;
        @(negedge Clk) $finish;
   end

endmodule // aoi_runtest
