/*
 * string of three flip-flops to demonstrate doverilog
 */

module fdel(Clk, a, a3);
   input   Clk;
   input   a;
   output  a3;

   wire    a, a1, a2, a3;
   FF f1(Clk, a, a1);
   FF f2(Clk, a1, a2);
   FF f3(Clk, a2, a3);

endmodule // aoi

/*
 * one of many ways to model a flip-flop
 */

module FF(clk,in,out);
   parameter Tcq=1;
   input     clk;
   input     in;
   output    out;
   reg 	     tmp;
   wire      out;
   always @(posedge clk) 
       tmp <= in ;
   assign #Tcq out = tmp ;
endmodule
