#
# dospice_tspice.pl -
# Configure dospice for use with Tanner Research's T-SPICE.
#

#
# return array of commands to be used as a pipeline to preprocess
# main netlist (.fa) file.
#
sub spice_get_fa_preproc_cmds
{
	return ($blib . "/cfa2hspice");
}

#
# get the command to run spice.
#
sub spice_get_command
{
	if($path_tspice) {
		return $path_tspice;	# should be set in dotools.pl file
	} else {
		return "tspice"; # else, hope its in the $PATH
	}
}

#
# Return list of command line arguments to pass to spice simulator
#
sub spice_get_args
{
	my($input_name, $input_basename) = @_;

	return('-M',
	       '-o',
	       $input_basename . '.ttr',
	       $input_name);
}

#
# given the spice input file name, return the output file name that we
# expect it to put the transient simulation output in.
#
sub spice_get_outfile_name
{
	my($input_basename) = @_;
	return $input_basename . '.ttr';
}

# return name of spice output file format, for use with spice2out
sub spice_get_outfile_format
{
	return 'cazm';
}

#
# funky processing of spice output files - tspice doesn't need any!
#
sub spice_outfile_hook
{
	my($rootname) = @_;

	return 1;
}

1;
