* command file for simulating a clock buffer to create 
* standard clock waveforms for use in simulating the rest of the system.

* this gets set to the period passed to spicepp on the command line
.PARAM period = __period__
.PARAM rftime = '0.01 * period'

* time in the cycle where we start the first transition,
* as a fraction of the total clock period.
.PARAM stfrac = '0.05'

vVdd Vdd GND vsupply

* Piecewise-linear idealized clock input waveform.
 
vclkin clkin gnd pwl 
+ 0					vsupply
+ 'stfrac*period'			vsupply
+ 'stfrac*period + rftime'		0
+ 'period/2 + period*stfrac' 		0
+ 'period/2 + period*stfrac + rftime'	vsupply
+ 'period'				vsupply

.trans 0.01n 'period'

.plot v(ClkIn) v(Ck1) v(Ck2) v(Ck3) v(Ck4) v(Clk)
.options post=2 probe

