* command file for testing sampled clock waveform against
* the actual output of the tapered buffer.

* load pwl waveform from clock file
@clock PWLClk GND Clock

* most of the rest of this is copied directly from ckbuf.cmd

* this gets set to the period passed to spicepp on the command line
.PARAM period = __period__
.PARAM rftime = '0.01 * period'

* time in the cycle where we start the first transition,
* as a fraction of the total clock period.
.PARAM stfrac = '0.05'

vVdd Vdd GND vsupply

* Piecewise-linear idealized clock input waveform.
 
vclkin clkin gnd pwl 
+ 0					vsupply
+ 'stfrac*period'			vsupply
+ 'stfrac*period + rftime'		0
+ 'period/2 + period*stfrac' 		0
+ 'period/2 + period*stfrac + rftime'	vsupply
+ 'period'				vsupply  R

.trans 0.01n '3*period'

.plot v(ClkIn) v(Ck1) v(Ck2) v(Ck3) v(Ck4) v(Clk) v(PWLClk) par('v(PWLClk)-v(Clk)')
.options post=2 probe

