* command file for testing sampled/generated waveforms
* against the original differential flip-flop outputs.

* spicepp will insert the period here
.PARAM period = __period__

@clock Clk GND Clock

vVdd Vdd GND vsupply

vdinh DH GND pwl
+ 0				 vsupply
+ 'period+period/4'		 vsupply
+ 'period+period/4+0.1n'		0
+ '2*period+period/4'		0
+ '2*period+period/4+0.1n'	vsupply
+ '4*period'			vsupply

vdinl DL GND pwl
+ 0				0
+ 'period+period/4'		0
+ 'period+period/4+0.1n'	vsupply
+ '2*period+period/4'		vsupply
+ '2*period+period/4+0.1n'	0
+ '4*period'			0

.ic v(x1.sah)=vsupply v(x1.sal)=0 v(x1.qqh)=vsupply v(x1.qql)=0 
.ic v(x2.sah)=vsupply v(x2.sal)=0 v(x2.qqh)=vsupply v(x2.qql)=0

* generate waveforms from previously sampled templates
@wavebit etfo_Q0H  GND {1011} ETFO=0+0,R,petff
@wavebit etfo_Q10H GND {1011} ETFO=10+0,R,petff

.trans 0.05n '5*period'

.option probe post=2

.probe v(Clk) v(Q0H) v(Q10H) v(DH) v(etfo_Q0H) v(etfo_Q10H)
+ par('v(etfo_Q0H)-v(Q0H)') par('v(etfo_Q10H)-v(Q10H)')
