#
# Slightly modified version of JP's awk script for extracting 
# waveform templates from simulation of standard flip-flop.
#

BEGIN {
    steps = 5;  # number of voltage steps between Vdd and GND
    period = 3.33; # clock period; change to 10 for "slow" to 8 for "fast"
    astate = -1;
    bstate = -1;
    acount = 0;
    bcount = 0;
    Vdd = 2.5;
    trip_delta = 0.01*Vdd
    first = 1;
}

{
if(first) {
	told = 0;
	vaold = Vdd;
	vbold = Vdd;
	astate = 0;
	bstate = 0;
        hitrip = Vdd - trip_delta ;
        lotrip = trip_delta ;
	first = 0;
}
    # Look for waveform dropping below Vdd:
    tnew = $1;
    vanew = $2;
    vbnew = $3;
    if ((astate == 0) && (vanew < hitrip )) {
	prop = (hitrip - vanew)/(vaold - vanew) ;
	tdna[0] = tnew - prop * (tnew - told);
	astate = 1;
	acount = acount + 1 ;
    }
    if ((bstate == 0) && (vbnew < hitrip )) {
	prop = (hitrip - vbnew)/(vbold - vbnew) ;
	tdnb[0] = tnew - prop * (tnew - told);
	bstate = 1;
	bcount = bcount + 1 ;
    }
    # Look for waveform falling below each of the voltage sample points,
    # then interpolate backwards to get the time of crossing.
    if (astate == 1) {
        asample = Vdd - (acount * Vdd/steps);
	while (vanew < asample) {
	    prop = (asample - vanew)/(vaold - vanew);
	    tdna[acount] = tnew - prop * (tnew - told);
	    acount = acount + 1 ;
            asample = Vdd - (acount * Vdd/steps);
	    if (acount == steps) astate = 2;
	}
    }
    if (bstate == 1) {
        bsample = Vdd - (bcount * Vdd/steps);
	while (vbnew < bsample) {
	    prop = (bsample - vbnew)/(vbold - vbnew);
	    tdnb[bcount] = tnew - prop * (tnew - told);
	    bcount = bcount + 1 ;
            bsample = Vdd - (bcount * Vdd/steps);
	    if (bcount == steps) bstate = 2;
	}
    }
    # Look for waveform getting within lotrip of GND, and interp to get time;
    if ((astate == 2) && (vanew < lotrip)) {
	prop = (lotrip - vanew)/(vaold - vanew);
	tdna[acount] = tnew - prop * (tnew - told);
	acount = 0; # reset acount for upward transition
	astate = 3;
    }
    if ((bstate == 2) && (vbnew < lotrip)) {
	prop = (lotrip - vbnew)/(vbold - vbnew);
	tdnb[bcount] = tnew - prop * (tnew - told);
	bcount = 0; # reset bcount for upward transition
	bstate = 3;
    }
    # Look for waveform rising about lotrip again
    if ((astate == 3) && (vanew > lotrip)) {
	prop = (vanew - lotrip)/(vanew - vaold);
	tupa[0] = tnew - prop * (tnew - told);
	astate = 4;
	acount = acount + 1 ;
    }
    if ((bstate == 3) && (vbnew > lotrip)) {
	prop = (vbnew - lotrip)/(vbnew - vbold);
	tupb[0] = tnew - prop * (tnew - told);
	bstate = 4;
	bcount = bcount + 1 ;
    }
    # Look for waveform rising through each of the voltage samples, interp.
    if (astate == 4) {
	asample = acount * Vdd/steps;
	while (vanew > asample) {
	    prop = (vanew - asample)/(vanew - vaold);
	    tupa[acount] = tnew - prop * (tnew - told);
	    acount = acount + 1 ;
	    asample = acount * Vdd/steps;
	    if (acount == steps) astate = 5;
	}
    }
    if (bstate == 4) {
	bsample = bcount * Vdd/steps;
	while (vbnew > bsample) {
	    prop = (vbnew - bsample)/(vbnew - vbold);
	    tupb[bcount] = tnew - prop * (tnew - told);
	    bcount = bcount + 1 ;
	    bsample = bcount * Vdd/steps;
	    if (bcount == steps) bstate = 5;
	}
    }
    # Look for waveform getting above hitrip to terminate.
    if ((astate == 5) && (vanew > hitrip)) {
	prop = (vanew - hitrip)/(vanew - vaold);
	tupa[acount] = tnew - prop * (tnew - told);
	astate = 6; # to finish
    }
    if ((bstate == 5) && (vbnew > hitrip)) {
	prop = (vbnew - hitrip)/(vbnew - vbold);
	tupb[bcount] = tnew - prop * (tnew - told);
	bstate = 6; # to finish
    }
    told = tnew;
    vaold = vanew;
    vbold = vbnew;
}

# subtract off period/2 from all waveform times because
# a positive-edge triggered flip-flop is being used.
# subtract another whole period off "up" waveforms because 
# the rising edge of the data occured at the second cycle of the simulation.
# This should be parameterized.
# 
END {
    printf("down\n");
    for (i=0; i <= steps; i++)
     printf("%4.3f %4.3f %4.3f\n",Vdd - i*(Vdd/steps),
     	1e9*tdna[i] - period/2,
        1e9*tdnb[i] - period/2);
    printf("up\n");
    for (i=0; i <= steps; i++)
     printf("%4.3f %4.3f %4.3f\n",
     	i*(Vdd/steps),
 	1e9*tupa[i] - period * 1.5,
     	1e9*tupb[i] - period * 1.5);

#     printf("#period=%f Vdd=%f hitrip=%f\n", period, Vdd, hitrip);
}
