/* gett.h

DESCRIPTION
   Header file gett system.  The data in this program is of two basic types:
   nodes and variables.  A node corresponds to an electrical node whose 
   waveform is plotted in the 'time' section of the input file.  A variable
   is simply a variable, usually associated with time.

HISTORY
    written 6/6/88 by Steven Molnar

---------------------------------------------------------*/

#include <stdio.h>

/* Mnemonic defines */

#define TRUE                      1
#define FALSE                     0
#define min(a,b)                  ((a)<(b)?(a):(b))
#define max(a,b)                  ((a)>(b)?(a):(b))

/* Maximum defines */

#define MAX_NAME_LEN              48
#define MAX_INPUT_FILES           50
#define MAX_SIGNALS               1000  
#define MAX_VARS                  10000
#define MAX_CYCLES                1000

/* Default defines */

#define DEFAULT_VDD               5.0

/* Finite State Machine states */

#define PRE                       3
#define XHorHX                    4
#define XLorLX                    5
#define HH                        6
#define HX                        7
#define XL                        8
#define LL                        9
#define LX                        10
#define XH                        11


/***************************************************************************
  Type definitions                         
***************************************************************************/

/* Typedef for an electrical signal */

typedef struct SignalStruct {
  char               name[MAX_NAME_LEN];
  float              Vdd;	               /* transition voltage defns */
  float              L;
  float              X;
  float              H;
  int                state;	               /* current state (for FSM) */
  float              V; 	               /* actual voltage */
  float              OldV;	               /* ditto (at previous) */
  float              RL[MAX_CYCLES];           /* hold transition times */
  float              RX[MAX_CYCLES];
  float              RH[MAX_CYCLES];
  float              FL[MAX_CYCLES];
  float              FX[MAX_CYCLES];
  float              FH[MAX_CYCLES];
  int                nRL, nRX, nRH;            /* counters */
  int                nFL, nFX, nFH;
} SIGNAL;

/* Typedef for a time variable */

typedef struct VarStruct {
  char               name[MAX_NAME_LEN];     /* variable's name */
  float              value;	             /* eventual value of variable */
  struct ExprStruct *expr;	             /* defining expression */
  int                valid;	             /* set when value is valid */
} VAR;

/* Typedef defining a waveform transition */

typedef struct TransStruct {
  SIGNAL            *signal;	             /* signal we're interested in */
  int                rf;	             /* rising or falling transition */
  int                trans;	             /* L, X, or H */
  int                num;	             /* which cycle (starting at 0) */
} TRANS;

/* Typedef for an expression node (for parse tree ) */

typedef struct ExprStruct {
  int                type;                   /* expression type */
  struct ExprStruct *arg1, *arg2;            /* expression args */
  union {
    float            value;	             /* value if a constant */
    VAR             *var;	             /* variable */
    TRANS            trans;	             /* transition */
  } contents;
} EXPR;


/***************************************************************************
*  Inter-module function declarations 
***************************************************************************/

